/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.ClassIterator;
import org.codefilarete.tool.bean.InterfaceIterator;
import org.codefilarete.tool.bean.MethodIterator;
import org.codefilarete.tool.collection.FilteringIterator;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.ReadOnlySet;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ReadOnlySetTest {
    private static final Set<Method> MUTATING_METHODS = new HashSet<Method>();
    private static final Set<Method> ITERATOR_MUTATING_METHODS = new HashSet<Method>();
    private static final Set<Method> EQUALS_HASHCODE_METHODS = new HashSet<Method>();

    ReadOnlySetTest() {
    }

    @Test
    void readOnlyMethodsThrowException() {
        Set delegate = (Set)Mockito.mock(Set.class);
        Assertions.setMaxStackTraceElementsDisplayed((int)100);
        Condition hasUnsupportedOperationExceptionInTrace = new Condition(thrownException -> Exceptions.findExceptionInCauses((Throwable)thrownException, UnsupportedOperationException.class) != null, "exception stack contains " + UnsupportedOperationException.class.getSimpleName(), new Object[0]);
        ReadOnlySet testInstance = new ReadOnlySet(delegate);
        for (Method method : MUTATING_METHODS) {
            Object[] args = new Object[method.getParameterCount()];
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> arg = parameterTypes[i];
                args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
            }
            Assertions.assertThatThrownBy(() -> {
                try {
                    method.invoke((Object)testInstance, args);
                }
                catch (IllegalArgumentException | ReflectiveOperationException e) {
                    throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
                }
            }).satisfies(hasUnsupportedOperationExceptionInTrace);
        }
    }

    @Test
    void listIteratorMethodsInvokeDelegateMethods() {
        Set set = (Set)Mockito.mock(Set.class);
        Iterator delegate = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when(set.iterator()).thenReturn((Object)delegate);
        Iterator testInstance = new ReadOnlySet(set).iterator();
        List iteratorClassInheritance = Iterables.copy((Iterator)new InterfaceIterator((Iterator)new ClassIterator(Iterator.class, null)));
        iteratorClassInheritance.add(0, Iterator.class);
        MethodIterator methodInHierarchyIterator = new MethodIterator(iteratorClassInheritance.iterator());
        FilteringIterator nonMutatingMethodsIterator = new FilteringIterator((Iterator)methodInHierarchyIterator, m -> !ITERATOR_MUTATING_METHODS.contains(m) && !EQUALS_HASHCODE_METHODS.contains(m));
        Iterable methods = () -> nonMutatingMethodsIterator;
        int methodCount = 0;
        for (Method method : methods) {
            try {
                Object[] args = new Object[method.getParameterCount()];
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> arg = parameterTypes[i];
                    args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
                }
                Object invocationResult = method.invoke((Object)testInstance, args);
                Object delegateResult = method.invoke(Mockito.verify((Object)delegate), args);
                Assertions.assertThat((Object)invocationResult).isEqualTo(delegateResult);
                Mockito.clearInvocations((Object[])new Iterator[]{delegate});
                ++methodCount;
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
            }
        }
        Assertions.assertThat((int)methodCount).isEqualTo(3);
    }

    @Test
    void readOnlyIteratorMethodsThrowException() {
        Set delegate = (Set)Mockito.mock(Set.class);
        Condition hasUnsupportedOperationExceptionInTrace = new Condition(thrownException -> Exceptions.findExceptionInCauses((Throwable)thrownException, UnsupportedOperationException.class) != null, "exception stack contains " + UnsupportedOperationException.class.getSimpleName(), new Object[0]);
        Iterator testInstance = new ReadOnlySet(delegate).iterator();
        for (Method method : ITERATOR_MUTATING_METHODS) {
            Object[] args = new Object[method.getParameterCount()];
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> arg = parameterTypes[i];
                args[i] = arg.isArray() ? Array.newInstance(arg.getComponentType(), 0) : Reflections.PRIMITIVE_DEFAULT_VALUES.getOrDefault(arg, null);
            }
            Assertions.assertThatThrownBy(() -> {
                try {
                    method.invoke((Object)testInstance, args);
                }
                catch (IllegalArgumentException | ReflectiveOperationException e) {
                    throw new RuntimeException("Error executing " + Reflections.toString((Method)method), e);
                }
            }).satisfies(hasUnsupportedOperationExceptionInTrace);
        }
    }

    static {
        try {
            EQUALS_HASHCODE_METHODS.add(Set.class.getMethod("equals", Object.class));
            EQUALS_HASHCODE_METHODS.add(Set.class.getMethod("hashCode", new Class[0]));
            MUTATING_METHODS.add(Set.class.getMethod("add", Object.class));
            MUTATING_METHODS.add(Set.class.getMethod("addAll", Collection.class));
            MUTATING_METHODS.add(Set.class.getMethod("remove", Object.class));
            MUTATING_METHODS.add(Set.class.getMethod("removeIf", Predicate.class));
            MUTATING_METHODS.add(Set.class.getMethod("removeAll", Collection.class));
            MUTATING_METHODS.add(Set.class.getMethod("retainAll", Collection.class));
            MUTATING_METHODS.add(Set.class.getMethod("clear", new Class[0]));
            ITERATOR_MUTATING_METHODS.add(Iterator.class.getMethod("remove", new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

